// slab with SQ lattice, hollow inclusion
a=1.0;
h=0.5;
d=0.95;
r=d/2.0;

// Points defining the unit-cell
lc=a/10.0; // mesh density
p1=newp; Point(p1) = {-a/2.0,-a/2.0,0.0,lc};
p2=newp; Point(p2) = {+a/2.0,-a/2.0,0.0,lc};
p3=newp; Point(p3) = {+a/2.0,+a/2.0,0.0,lc};
p4=newp; Point(p4) = {-a/2.0,+a/2.0,0.0,lc};

p21=newp; Point(p21) = {0,0,0,lc};
p22=newp; Point(p22) = {r,0,0,lc};
p23=newp; Point(p23) = {0,r,0,lc};
p24=newp; Point(p24) = {-r,0,0,lc};
p25=newp; Point(p25) = {0,-r,0,lc};

// Lines
l1=newl; Line(l1) = {p1,p2};
l2=newl; Line(l2) = {p2,p3};
l3=newl; Line(l3) = {p3,p4};
l4=newl; Line(l4) = {p4,p1};

c1=newl; Circle(c1) = {p22,p21,p23};
c2=newl; Circle(c2) = {p23,p21,p24};
c3=newl; Circle(c3) = {p24,p21,p25};
c4=newl; Circle(c4) = {p25,p21,p22};

// Surfaces
ll5=newll; Line Loop(ll5)={-l1,-l4,-l3,-l2};
ll15=newll; Line Loop(ll15)={c1,c2,c3,c4};
s5=news; Plane Surface(s5) = {ll5,ll15}; Physical Surface(5) = {s5};

Extrude{0,0,h}{ Surface{s5}; }

Transfinite Surface{28}={4,1,11,15}; Physical Surface(1) = {28};
Transfinite Surface{24}={1,2,10,11}; Physical Surface(2) = {24};
Transfinite Surface{36}={3,2,10,19}; Physical Surface(3) = {36};
Transfinite Surface{32}={4,3,19,15}; Physical Surface(4) = {32};
Physical Surface(6) = {53};
Physical Surface(7) = {40,44,48,52};

// Volumes
Physical Volume(1) = {1};

