// slab with HEX lattice, hollow inclusion
a=1.0;
h=0.6;
d=0.9;
r=d/2.0;
a1=a/Sqrt(3.0);
a2=a1/2.0;

// Points defining the unit-cell
lc=a/12.0; // mesh density
p1=newp; Point(p1) = {0.0,a1,0.0,lc};
p2=newp; Point(p2) = {-a/2.0,a2,0.0,lc};
p3=newp; Point(p3) = {-a/2.0,-a2,0.0,lc};
p4=newp; Point(p4) = {0.0,-a1,0.0,lc};
p5=newp; Point(p5) = {a/2.0,-a2,0.0,lc};
p6=newp; Point(p6) = {a/2.0,a2,0.0,lc};

p21=newp; Point(p21) = {0,0,0,lc};
p22=newp; Point(p22) = {r,0,0,lc};
p23=newp; Point(p23) = {0,r,0,lc};
p24=newp; Point(p24) = {-r,0,0,lc};
p25=newp; Point(p25) = {0,-r,0,lc};

// Lines
l1=newl; Line(l1) = {p1,p2};
l2=newl; Line(l2) = {p2,p3};
l3=newl; Line(l3) = {p3,p4};
l4=newl; Line(l4) = {p4,p5};
l5=newl; Line(l5) = {p5,p6};
l6=newl; Line(l6) = {p6,p1};

c1=newl; Circle(c1) = {p22,p21,p23};
c2=newl; Circle(c2) = {p23,p21,p24};
c3=newl; Circle(c3) = {p24,p21,p25};
c4=newl; Circle(c4) = {p25,p21,p22};

// Surfaces
ll5=newll; Line Loop(ll5)={l1,l2,l3,l4,l5,l6};
ll15=newll; Line Loop(ll15)={c1,c2,c3,c4};
s5=news; Plane Surface(s5) = {ll5,ll15}; Physical Surface(7) = {s5};

Extrude{0,0,h}{ Surface{s5}; }

Transfinite Surface{28}={1,2,13,12}; Physical Surface(1) = {28};
Transfinite Surface{32}={2,3,17,13}; Physical Surface(2) = {32};
Transfinite Surface{36}={3,4,21,17}; Physical Surface(3) = {36};
Transfinite Surface{40}={5,4,21,25}; Physical Surface(4) = {40};
Transfinite Surface{44}={6,5,25,29}; Physical Surface(5) = {44};
Transfinite Surface{48}={1,6,29,12}; Physical Surface(6) = {48};
Physical Surface(8) = {65};
Physical Surface(9) = {52,56,60,64};

// Volumes
Physical Volume(1) = {1};

