// slab with HC lattice, hollow inclusion
a=1.0;
h=0.6;
d=0.5;
r=d/2.0;
a1=a/2.0;
a2=Sqrt(3.0)/2.0;
c=1.0/Sqrt(3.0)/2.0;

// Points defining the unit-cell
lc=a/10.0; // mesh density
p1=newp; Point(p1) = {0.0,-a2,0.0,lc};
p2=newp; Point(p2) = {a1,0.0,0.0,lc};
p3=newp; Point(p3) = {0.0,a2,0.0,lc};
p4=newp; Point(p4) = {-a1,0.0,0.0,lc};

p21=newp; Point(p21) = {0,c,0,lc};
p22=newp; Point(p22) = {r,c,0,lc};
p23=newp; Point(p23) = {0,c+r,0,lc};
p24=newp; Point(p24) = {-r,c,0,lc};
p25=newp; Point(p25) = {0,c-r,0,lc};

p31=newp; Point(p31) = {0,-c,0,lc};
p32=newp; Point(p32) = {r,-c,0,lc};
p33=newp; Point(p33) = {0,-c+r,0,lc};
p34=newp; Point(p34) = {-r,-c,0,lc};
p35=newp; Point(p35) = {0,-c-r,0,lc};

// Lines
l1=newl; Line(l1) = {p1,p2};
l2=newl; Line(l2) = {p2,p3};
l3=newl; Line(l3) = {p3,p4};
l4=newl; Line(l4) = {p4,p1};

c1=newl; Circle(c1) = {p22,p21,p23};
c2=newl; Circle(c2) = {p23,p21,p24};
c3=newl; Circle(c3) = {p24,p21,p25};
c4=newl; Circle(c4) = {p25,p21,p22};

c5=newl; Circle(c5) = {p32,p31,p33};
c6=newl; Circle(c6) = {p33,p31,p34};
c7=newl; Circle(c7) = {p34,p31,p35};
c8=newl; Circle(c8) = {p35,p31,p32};

// Surfaces
ll1=newll; Line Loop(ll1)={-l1,-l4,-l3,-l2};
ll2=newll; Line Loop(ll2)={c1,c2,c3,c4};
ll3=newll; Line Loop(ll3)={c5,c6,c7,c8};
s1=news; Plane Surface(s1) = {ll1,ll2,ll3}; Physical Surface(5) = {s1};

Extrude{0,0,h}{ Surface{s1}; }

Transfinite Surface{37}={4,1,16,20}; Physical Surface(1) = {37};
Transfinite Surface{33}={1,2,15,16}; Physical Surface(2) = {33};
Transfinite Surface{45}={3,2,15,24}; Physical Surface(3) = {45};
Transfinite Surface{41}={4,3,24,20}; Physical Surface(4) = {41};
Physical Surface(6) = {78};
Physical Surface(7) = {49,53,57,61,65,69,73,77};

// Volumes
Physical Volume(1) = {1};

