set terminal png enhanced
set output "fiber_silica.png"
set xlabel "k/(2{/Symbol p})"
set ylabel "{/Symbol w}/c = 1/{/Symbol l}_0"
set title "Optical waveguide"
f(x)=x
g(x)=x/1.45 # silica
h(x)=x/3.6 # silicon
plot "fiber_silica.txt" u 1:2 notitle, f(x) title "light line", g(x) title "silica line"

set output "fiber_silicon.png"
plot "fiber_silicon.txt" u 1:2 notitle, f(x) title "light line", h(x) title "silicon line"

