data = load('fiber_silica.txt', '-ascii'); % read text file formatted in columns
k = data(:,1); % column 1 of the data text file
f = data(:,2); % column 2 of the data text file

f1=k./1.0; % air
f2=k./1.45; % silica
f3=k./3.6; % silicon

figure(1)
plot(k, f, 'o') % plot with points
xlabel('k/(2\pi)', 'interpreter', 'tex');
ylabel('\omega/c', 'interpreter', 'tex');
hold on;
plot(k, f1);
plot(k, f2);
hold off;
