# gnuplot script to generate band structures of artificial crystals

set term png enhanced

set xl "Reduced wavenumber, ka/2\{/Symbol p}"
set yl "Reduced frequency, {/Symbol w} a/2\{/Symbol p} (m/s)"
set style data points
set grid

###############################################################################
set output "TE.png"
set xr [*:*]
set xtics ("M" -1, "{/Symbol G}" 0.0, "X" 1, "M" 2)
set yr [0:0.5]
plot "bs_TE.dat" i 0 u ($1*2.0):4 not, "" i 1 u (-$1*2.0):4 not, "" i 2 u ($2*2.0+1.0):4 not

set output "TM.png"
set xr [*:*]
set xtics ("M" -1, "{/Symbol G}" 0.0, "X" 1, "M" 2)
set yr [0:0.5]
plot "bs_TM.dat" i 0 u ($1*2.0):4 not, "" i 1 u (-$1*2.0):4 not, "" i 2 u ($2*2.0+1.0):4 not
