# gnuplot script to generate band structures of artificial crystals

a=1.0e-6 # lattice constant in m

set term png enhanced

set xl "Reduced wavenumber, ka/2\{/Symbol p}"
set yl "Reduced frequency, {/Symbol w} a/2\{/Symbol p} (m/s)"
set style data points
set grid

###############################################################################
# air/rigid
set output "bs_acoustic.png"
set xr [*:*]
set xtics ("M" -1, "{/Symbol G}" 0.0, "X" 1, "M" 2)
set yr [0:2000]
plot "bs_acoustic.dat" i 0 u ($1*2.0):($4*a) not, "" i 1 u (-$1*2.0):($4*a) not, "" i 2 u ($2*2.0+1.0):($4*a) not
