CREATE TABLE 'ArtCategories' (
  'categoryId' INTEGER PRIMARY KEY,
  'categoryName' varchar(255) NOT NULL
); 
INSERT INTO 'ArtCategories' ('categoryId', 'categoryName') VALUES
(1, 'Painting'),
(2, 'Sculpture');


CREATE TABLE 'Artists' (
  'artistId'INTEGER PRIMARY KEY,
  'artistName' varchar(255) NOT NULL,
  'birthDate' TEXT DEFAULT NULL,
  'nationality' varchar(100) DEFAULT NULL
);

INSERT INTO 'Artists' ('artistId', 'artistName', 'birthDate', 'nationality') VALUES
(1, 'Pablo Picasso', '1881-10-25', 'Spanish'),
(2, 'Claude Monet', '1840-11-14', 'French'),
(3, 'Vincent van Gogh', '1853-03-30', 'Dutch'),
(4, 'Leonardo da Vinci', '1452-04-15', 'Italian'),
(5, 'Frida Kahlo', '1907-07-06', 'Mexican'),
(6, 'Jackson Pollock', '1912-01-28', 'American'),
(7, 'Georgia O Keefe', '1887-11-15', 'American'),
(8, 'Salvador Dali', '1904-05-11', 'Spanish'),
(9, 'Edvard Munch', '1863-12-12', 'Norwegian'),
(10, 'Rembrandt', '1606-07-15', 'Dutch'),
(11, 'Diego Velázquez', '1599-06-06', 'Spanish'),
(12, 'Michelangelo Buonarroti', '1475-03-06', 'Italian'),
(13, 'Andy Warhol', '1928-08-06', 'American'),
(14, 'Claude Debussy', '1862-08-22', 'French'),
(15, 'Wassily Kandinsky', '1866-12-16', 'Russian'),
(16, 'Gustav Klimt', '1862-07-14', 'Austrian'),
(17, 'Paul Klee', '1879-12-18', 'Swiss'),
(18, 'Henri Matisse', '1869-12-31', 'French'),
(19, 'Diego Rivera', '1886-12-08', 'Mexican');

CREATE TABLE 'Artworks' (
  'artworkId'INTEGER PRIMARY KEY,
  'artworkTitle' varchar(255) NOT NULL,
  'artistId' INTEGER NOT NULL,
  'creationDate' date DEFAULT NULL,
  'medium' varchar(255) DEFAULT NULL,
  'price' decimal(13,2) DEFAULT NULL,
  FOREIGN KEY ('artistId') REFERENCES 'Artists' ('artistId') ON DELETE CASCADE);


INSERT INTO 'Artworks' ('artworkId', 'artworkTitle', 'artistId', 'creationDate', 'medium', 'price') VALUES
(101, 'Guernica', 1, '1937-09-05', 'Oil on canvas', '10000000.00'),
(102, 'Water Lilies', 2, '1919-01-01', 'Oil on canvas', '8000000.00'),
(103, 'Starry Night', 3, '1889-06-01', 'Oil on canvas', '12000000.00'),
(104, 'Mona Lisa', 4, '1503-04-15', 'Oil on poplar', '150000000.00'),
(105, 'The Two Fridas', 5, '1939-09-25', 'Oil on canvas', '9000000.00'),
(106, 'Number 1A, 1948', 6, '1948-01-01', 'Oil and enamel on canvas', '14000000.00'),
(107, 'O Keeffe s Calla Lilies', 7, '1928-01-01', 'Oil on canvas', '7500000.00'),
(108, 'The Persistence of Memory', 8, '1931-01-01', 'Oil on canvas', '18000000.00'),
(109, 'The Scream', 9, '1893-01-01', 'Oil, tempera, and pastel on cardboard', '20000000.00'),
(110, 'The Night Watch', 10, '1642-01-01', 'Oil on canvas', '30000000.00'),
(111, 'Las Meninas', 11, '1656-01-01', 'Oil on canvas', '25000000.00'),
(112, 'David', 12, '1501-01-01', 'Marble', '12000000.00'),
(113, 'Campbell s Soup Cans', 13, '1962-01-01', 'Acrylic on canvas', '25000000.00'),
(114, 'La Mer', 14, '1905-01-01', 'Oil on canvas', '15000000.00'),
(115, 'Composition VII', 15, '1913-01-01', 'Oil on canvas', '20000000.00'),
(116, 'The Kiss', 16, '1907-01-01', 'Oil on canvas', '22000000.00'),
(117, 'Castle and Sun', 17, '1928-01-01', 'Oil on canvas', '8000000.00'),
(118, 'Dance', 18, '1910-01-01', 'Oil on canvas', '16000000.00'),
(119, 'Man with a Guitar', 19, '1934-01-01', 'Oil on canvas', '10000000.00');

-- --------------------------------------------------------


CREATE TABLE 'ArtworkCategorie' (
  'artworkId' INTEGER,
  'categoryId' INTEGER,
  FOREIGN KEY ('artworkId') REFERENCES 'Artworks' ('artworkId') ON DELETE CASCADE,
  FOREIGN KEY ('categoryId') REFERENCES 'ArtCategories' ('categoryId') ON DELETE CASCADE);

INSERT INTO 'ArtworkCategorie' ('artworkId', 'categoryId') VALUES
(101, 1),
(102, 1),
(103, 1),
(104, 1),
(105, 1),
(106, 1),
(107, 1),
(108, 1),
(109, 1),
(110, 1),
(111, 1),
(113, 1),
(114, 1),
(115, 1),
(116, 1),
(117, 1),
(118, 1),
(119, 1),
(101, 2),
(103, 2),
(105, 2),
(112, 2);



CREATE TABLE 'Exhibitions' (
  'exhibitionId'INTEGER PRIMARY KEY,
  'exhibitionTitle' varchar(255) NOT NULL,
  'startDate' date DEFAULT NULL,
  'endDate' date DEFAULT NULL
);


INSERT INTO 'Exhibitions' ('exhibitionId', 'exhibitionTitle', 'startDate', 'endDate') VALUES
(201, 'Modern Masters', '2023-03-01', '2023-05-01'),
(202, 'Impressionists', '2023-04-15', '2023-08-15'),
(301, 'Impressionist Delights', '2023-02-15', '2023-06-15'),
(302, 'Modern Sculpture Showcase', '2023-07-01', '2023-09-01'),
(303, 'Abstract Art Unleashed', '2023-05-15', '2023-07-15'),
(304, 'Renaissance Wonders', '2023-08-15', '2023-10-15');



--
-- Structure de la table 'ExhibitionArtworks'
--

CREATE TABLE 'ExhibitionArtworks' (
  'exhibitionId'INTEGER NOT NULL,
  'artworkId'INTEGER NOT NULL,
  PRIMARY KEY ('exhibitionId','artworkId'),
  FOREIGN KEY ('exhibitionId') REFERENCES 'Exhibitions' ('exhibitionId') ON DELETE CASCADE,
  FOREIGN KEY ('artworkId') REFERENCES 'Artworks' ('artworkId') ON DELETE CASCADE
);

INSERT INTO 'ExhibitionArtworks' ('exhibitionId', 'artworkId') VALUES
(201, 101),
(301, 101),
(202, 102),
(301, 102),
(301, 103),
(304, 104),
(303, 106),
(303, 110),
(304, 111),
(302, 112),
(303, 115),
(304, 116),
(302, 117),
(302, 118),
(304, 119);

