# Installation instructions

This file provides instructions to install and use a virtual machine (a 'container' in docker terminology)
with Why3 and Cubicle. All Docker commands are shortened thanks to Makefile entries.

- Download the svfmtea2023presentedcoursematerial.zip archive at the URL
  [https://members.femto-st.fr/alain-giorgetti/en](https://members.femto-st.fr/alain-giorgetti/en).

- Extract this archive to a local folder on your computer. Be sure to choose a folder whose complete
  name, from the root, does not contain any characters that may cause problems, such as spaces,
  accents, etc. In the following, we assume that the full path of the extracted folder is
  /home/me/svFMTea2023presentedCourseMaterial/.

- The rest of the installation is done from the command line. Open a console (a terminal) and move 
  to the extracted folder, adapting the command

        cd /home/me/svFMTea2023presentedCourseMaterial

  to your situation.

## Installation with Docker

- If Docker is not installed, follow the instructions at
  [https://docs.docker.com/get-docker/](https://docs.docker.com/get-docker/)
  to install Docker for your OS.

- If your OS is Linux, then follow the instructions at
  [https://docs.docker.com/engine/install/linux-postinstall/](https://docs.docker.com/engine/install/linux-postinstall/)
  to run Docker commands without using sudo.

### Installation for Linux or macOS

- Build the Docker image:

        make build

   The Docker image will contain compatible releases of all the required tools.

   Warnings: The Docker image is a large file, its construction can be very long.
   A network connection is required. If you already have a Docker image with this
   name, then rename it, remove it or change the image name in Makefile and ctr.sh.

- Create the container:

        make ctr

  under Linux, or

        make ctrmac

  under macOS.

   Warnings: If you already have a Docker container with the same name, then rename it,
   remove it or change the container name in Makefile and ctr.sh. Make sure the root 
   folder where you write the command has no spaces.

- The previous operations have to be carried out only once, unlike the following operation,
  to do each time you want to use the working environment. Start an interactive session in 
  the container and move to the /data folder in it:

        make start
        cd /data

  The folder /data is associated with the folder /home/me/svFMTea2023presentedCourseMaterial
  of the host machine. Thus, you will write your Cubicle and Why3 files in this folder on the
  host machine and you will only use the container to launch Cubicle and Why3 commands. When
  you shut down the why3_cubicle_SV_ctr container, your data (your Cubicle and Why3 files) 
  remain accessible in this /home/me/svFMTea2023presentedCourseMaterial folder of your host machine.
  You can now run Cubicle and Why3 commands in the container.

- Finally, quit the container:

       exit

### Installation for Windows

1. Replace the file suffixes .bat2 by .bat

2. Run the command

     ./01_build_image.bat

   to build the Docker image containing compatible releases of all the required tools.

   Warnings: The Docker image is a large file, its construction can be very long.
   A network connection is required. If you already have a Docker image with this
   name, then rename it, remove it before.

3. Run the command

    ./02_create_container.bat

   to create the Docker container, named why3_cubicle_SV_ctr.

   Warning: If you already have a Docker container with the same name, then rename it before.

4. If not already done, create a C:\data folder on the host machine under Windows.

5. The previous operations have to be carried out only once, unlike the following operation,
  to do each time you want to use the working environment. Start an interactive session in 
  the container and move to the /data folder in it, with the following commands:

    ./03_start_container.bat
    cd /data

  The folder /data is associated with the folder C:\data of the host machine. Thus, you will
  write your Cubicle and Why3 files in this folder on the host machine and you will only use 
  the container to launch Cubicle and Why3 commands. When you shut down the why3_cubicle_SV_ctr
  container, your data (your Cubicle and Why3 files) remain accessible in this folder C:\data
  of your host machine. You can now run Cubicle and Why3 commands in the container.

- Finally, quit the container:

    exit

