(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require map.Map.
Require map.Occ.
Require map.MapPermut.
Require map.MapInjection.

(* Why3 assumption *)
Definition unit := unit.

(* Why3 assumption *)
Inductive ref (a:Type) :=
  | mk_ref : a -> ref a.
Axiom ref_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (ref a).
Existing Instance ref_WhyType.
Implicit Arguments mk_ref [[a]].

(* Why3 assumption *)
Definition contents {a:Type} {a_WT:WhyType a} (v:(ref a)): a :=
  match v with
  | (mk_ref x) => x
  end.

(* Why3 assumption *)
Inductive array (a:Type) :=
  | mk_array : Z -> (map.Map.map Z a) -> array a.
Axiom array_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (array a).
Existing Instance array_WhyType.
Implicit Arguments mk_array [[a]].

(* Why3 assumption *)
Definition elts {a:Type} {a_WT:WhyType a} (v:(array a)): (map.Map.map Z a) :=
  match v with
  | (mk_array x x1) => x1
  end.

(* Why3 assumption *)
Definition length {a:Type} {a_WT:WhyType a} (v:(array a)): Z :=
  match v with
  | (mk_array x x1) => x
  end.

(* Why3 assumption *)
Definition get {a:Type} {a_WT:WhyType a} (a1:(array a)) (i:Z): a :=
  (map.Map.get (elts a1) i).

(* Why3 assumption *)
Definition set {a:Type} {a_WT:WhyType a} (a1:(array a)) (i:Z) (v:a): (array
  a) := (mk_array (length a1) (map.Map.set (elts a1) i v)).

(* Why3 assumption *)
Definition injective (a:(array Z)): Prop := (map.MapInjection.injective
  (elts a) (length a)).

(* Why3 assumption *)
Definition surjective (a:(array Z)): Prop := (map.MapInjection.surjective
  (elts a) (length a)).

(* Why3 assumption *)
Definition range (a:(array Z)): Prop := (map.MapInjection.range (elts a)
  (length a)).

Axiom injective_surjective : forall (a:(array Z)), (injective a) -> ((range
  a) -> (surjective a)).

Axiom injection_occ : forall (a:(array Z)), (injective a) <-> forall (v:Z),
  ((map.Occ.occ v (elts a) 0%Z (length a)) <= 1%Z)%Z.

Axiom endoinjection_occ : forall (a:(array Z)), ((map.MapInjection.range
  (elts a) (length a)) /\ (injective a)) -> forall (v:Z), ((0%Z <= v)%Z /\
  (v < (length a))%Z) -> ((map.Occ.occ v (elts a) 0%Z (length a)) = 1%Z).

(* Why3 assumption *)
Definition map_eq_sub {a:Type} {a_WT:WhyType a} (a1:(map.Map.map Z a))
  (a2:(map.Map.map Z a)) (l:Z) (u:Z): Prop := forall (i:Z), ((l <= i)%Z /\
  (i < u)%Z) -> ((map.Map.get a1 i) = (map.Map.get a2 i)).

(* Why3 assumption *)
Definition array_eq_sub {a:Type} {a_WT:WhyType a} (a1:(array a)) (a2:(array
  a)) (l:Z) (u:Z): Prop := ((length a1) = (length a2)) /\ (((0%Z <= l)%Z /\
  (l <= (length a1))%Z) /\ (((0%Z <= u)%Z /\ (u <= (length a1))%Z) /\
  (map_eq_sub (elts a1) (elts a2) l u))).

(* Why3 assumption *)
Definition array_eq {a:Type} {a_WT:WhyType a} (a1:(array a)) (a2:(array
  a)): Prop := ((length a1) = (length a2)) /\ (map_eq_sub (elts a1) (elts a2)
  0%Z (length a1)).

(* Why3 assumption *)
Definition lt_lex_sub_at (a1:(array Z)) (a2:(array Z)) (l:Z) (u:Z)
  (i:Z): Prop := ((l <= i)%Z /\ (i < u)%Z) /\ ((array_eq_sub a1 a2 l i) /\
  ((get a1 i) < (get a2 i))%Z).

(* Why3 assumption *)
Definition lt_lex_at (a1:(array Z)) (a2:(array Z)) (i:Z): Prop :=
  ((length a1) = (length a2)) /\ (lt_lex_sub_at a1 a2 0%Z (length a1) i).

(* Why3 assumption *)
Definition lt_lex_sub (a1:(array Z)) (a2:(array Z)) (l:Z) (u:Z): Prop :=
  exists i:Z, (lt_lex_sub_at a1 a2 l u i).

(* Why3 assumption *)
Definition lt_lex (a1:(array Z)) (a2:(array Z)): Prop :=
  ((length a1) = (length a2)) /\ (lt_lex_sub a1 a2 0%Z (length a1)).

(* Why3 assumption *)
Definition le_lex_sub (a1:(array Z)) (a2:(array Z)) (l:Z) (u:Z): Prop :=
  (lt_lex_sub a1 a2 l u) \/ (array_eq_sub a1 a2 l u).

Axiom prefix_le_lex_sub : forall (a:(array Z)) (b:(array Z)) (l:Z) (u:Z),
  ((array_eq_sub a b 0%Z l) /\ (le_lex_sub a b l u)) -> (le_lex_sub a b 0%Z
  u).

Axiom not_array_eq_sub : forall (a:(array Z)) (b:(array Z)) (l:Z) (u:Z),
  (((0%Z <= (length a))%Z /\ (0%Z <= (length b))%Z) /\ (((0%Z <= l)%Z /\
  ((l < u)%Z /\ ((u <= (length a))%Z /\ ((length a) = (length b))))) /\
  ~ (array_eq_sub a b l u))) -> exists i:Z, ((l <= i)%Z /\ (i < u)%Z) /\
  ((array_eq_sub a b l i) /\ ~ ((get a i) = (get b i))).

Axiom total_order : forall (a:(array Z)) (b:(array Z)) (l:Z) (u:Z),
  (((0%Z <= l)%Z /\ ((l < u)%Z /\ ((u <= (length a))%Z /\
  ((length a) = (length b))))) /\ ~ (lt_lex_sub b a l u)) -> (le_lex_sub a b
  l u).

(* Why3 assumption *)
Definition exchange {a:Type} {a_WT:WhyType a} (a1:(map.Map.map Z a))
  (a2:(map.Map.map Z a)) (l:Z) (u:Z) (i:Z) (j:Z): Prop := ((l <= i)%Z /\
  (i < u)%Z) /\ (((l <= j)%Z /\ (j < u)%Z) /\ (((map.Map.get a1
  i) = (map.Map.get a2 j)) /\ (((map.Map.get a1 j) = (map.Map.get a2 i)) /\
  forall (k:Z), ((l <= k)%Z /\ (k < u)%Z) -> ((~ (k = i)) -> ((~ (k = j)) ->
  ((map.Map.get a1 k) = (map.Map.get a2 k))))))).

Axiom exchange_set : forall {a:Type} {a_WT:WhyType a},
  forall (a1:(map.Map.map Z a)) (l:Z) (u:Z) (i:Z) (j:Z), ((l <= i)%Z /\
  (i < u)%Z) -> (((l <= j)%Z /\ (j < u)%Z) -> (exchange a1
  (map.Map.set (map.Map.set a1 i (map.Map.get a1 j)) j (map.Map.get a1 i)) l
  u i j)).

(* Why3 assumption *)
Definition exchange1 {a:Type} {a_WT:WhyType a} (a1:(array a)) (a2:(array a))
  (i:Z) (j:Z): Prop := ((length a1) = (length a2)) /\ (exchange (elts a1)
  (elts a2) 0%Z (length a1) i j).

(* Why3 assumption *)
Definition permut {a:Type} {a_WT:WhyType a} (a1:(array a)) (a2:(array a))
  (l:Z) (u:Z): Prop := ((length a1) = (length a2)) /\ (((0%Z <= l)%Z /\
  (l <= (length a1))%Z) /\ (((0%Z <= u)%Z /\ (u <= (length a1))%Z) /\
  (map.MapPermut.permut (elts a1) (elts a2) l u))).

(* Why3 assumption *)
Definition permut_sub {a:Type} {a_WT:WhyType a} (a1:(array a)) (a2:(array a))
  (l:Z) (u:Z): Prop := (map_eq_sub (elts a1) (elts a2) 0%Z l) /\ ((permut a1
  a2 l u) /\ (map_eq_sub (elts a1) (elts a2) u (length a1))).

(* Why3 assumption *)
Definition permut_all {a:Type} {a_WT:WhyType a} (a1:(array a)) (a2:(array
  a)): Prop := ((length a1) = (length a2)) /\ (map.MapPermut.permut (elts a1)
  (elts a2) 0%Z (length a1)).

Axiom exchange_permut_sub : forall {a:Type} {a_WT:WhyType a},
  forall (a1:(array a)) (a2:(array a)) (i:Z) (j:Z) (l:Z) (u:Z), (exchange1 a1
  a2 i j) -> (((l <= i)%Z /\ (i < u)%Z) -> (((l <= j)%Z /\ (j < u)%Z) ->
  ((0%Z <= l)%Z -> ((u <= (length a1))%Z -> (permut_sub a1 a2 l u))))).

Axiom permut_sub_weakening : forall {a:Type} {a_WT:WhyType a},
  forall (a1:(array a)) (a2:(array a)) (l1:Z) (u1:Z) (l2:Z) (u2:Z),
  (permut_sub a1 a2 l1 u1) -> (((0%Z <= l2)%Z /\ (l2 <= l1)%Z) ->
  (((u1 <= u2)%Z /\ (u2 <= (length a1))%Z) -> (permut_sub a1 a2 l2 u2))).

Axiom exchange_permut_all : forall {a:Type} {a_WT:WhyType a},
  forall (a1:(array a)) (a2:(array a)) (i:Z) (j:Z), (exchange1 a1 a2 i j) ->
  (permut_all a1 a2).

(* Why3 assumption *)
Definition is_permut (a:(array Z)): Prop := (range a) /\ (injective a).

Axiom endoinj_permut : forall (a:(array Z)) (b:(array Z)),
  (((0%Z <= (length a))%Z /\ ((length a) = (length b))) /\ ((is_permut a) /\
  (is_permut b))) -> (permut a b 0%Z (length a)).

(* Why3 assumption *)
Definition is_id_sub (a:(array Z)) (l:Z) (u:Z): Prop := forall (i:Z),
  ((l <= i)%Z /\ (i < u)%Z) -> ((get a i) = i).

(* Why3 assumption *)
Definition im_sup1 (a:(array Z)) (r:Z) (k:Z): Prop := forall (i:Z),
  ((r < i)%Z /\ (i < k)%Z) -> ((get a k) < (get a i))%Z.

(* Why3 assumption *)
Definition im_sup2 (a:(array Z)) (r:Z) (k:Z): Prop := forall (i:Z),
  ((k < i)%Z /\ (i < (length a))%Z) -> ((get a i) < (get a r))%Z.

(* Why3 assumption *)
Definition is_inc_sub (a:(array Z)) (l:Z) (u:Z): Prop := forall (i:Z) (j:Z),
  ((l <= i)%Z /\ ((i < j)%Z /\ (j < u)%Z)) -> ((get a i) < (get a j))%Z.

(* Why3 assumption *)
Definition is_inc (a:(array Z)): Prop := (is_inc_sub a 0%Z (length a)).

(* Why3 assumption *)
Definition is_dec_sub (a:(array Z)) (l:Z) (u:Z): Prop := forall (i:Z) (j:Z),
  ((l <= i)%Z /\ ((i < j)%Z /\ (j < u)%Z)) -> ((get a j) < (get a i))%Z.

Axiom min_lex_sub : forall (a:(array Z)) (l:Z) (u:Z), (((0%Z <= l)%Z /\
  ((l < u)%Z /\ (u <= (length a))%Z)) /\ ((injective a) /\ (is_inc_sub a l
  u))) -> forall (b:(array Z)), ((permut a b l u) /\ (injective b)) ->
  (le_lex_sub a b l u).

Axiom max_lex_sub : forall (a:(array Z)) (l:Z) (u:Z), (((0%Z <= l)%Z /\
  ((l < u)%Z /\ (u <= (length a))%Z)) /\ ((injective a) /\ (is_dec_sub a l
  u))) -> forall (b:(array Z)), ((permut a b l u) /\ (injective b)) ->
  (le_lex_sub b a l u).

(* Why3 assumption *)
Definition min_lex (a:(array Z)): Prop := forall (b:(array Z)),
  (((length a) = (length b)) /\ (is_permut b)) -> (le_lex_sub a b 0%Z
  (length a)).

(* Why3 assumption *)
Definition max_lex (a:(array Z)): Prop := forall (b:(array Z)),
  (((length a) = (length b)) /\ (is_permut b)) -> (le_lex_sub b a 0%Z
  (length a)).

(* Why3 assumption *)
Definition inc (a1:(array Z)) (a2:(array Z)): Prop :=
  ((length a1) = (length a2)) /\ ((lt_lex_sub a1 a2 0%Z (length a1)) /\
  forall (a3:(array Z)), (((length a1) = (length a3)) /\ ((is_permut a3) /\
  (lt_lex_sub a1 a3 0%Z (length a1)))) -> (le_lex_sub a2 a3 0%Z
  (length a1))).

(* Why3 assumption *)
Inductive cursor :=
  | mk_cursor : (array Z) -> bool -> cursor.
Axiom cursor_WhyType : WhyType cursor.
Existing Instance cursor_WhyType.

(* Why3 assumption *)
Definition new (v:cursor): bool := match v with
  | (mk_cursor x x1) => x1
  end.

(* Why3 assumption *)
Definition current (v:cursor): (array Z) :=
  match v with
  | (mk_cursor x x1) => x
  end.

(* Why3 assumption *)
Definition sound (c:cursor): Prop := (is_permut (current c)).

Axiom split_inc_sub : forall (a:(array Z)) (l:Z) (m:Z) (u:Z),
  (((0%Z <= l)%Z /\ ((l <= m)%Z /\ ((m < u)%Z /\ (u <= (length a))%Z))) /\
  ((is_inc_sub a l (m + 1%Z)%Z) /\ (is_inc_sub a m u))) -> (is_inc_sub a l
  u).

Axiom permut_split : forall (a:(array Z)) (b:(array Z)) (l:Z),
  (((0%Z <= l)%Z /\ ((l < (length a))%Z /\ ((length a) = (length b)))) /\
  ((is_permut a) /\ ((is_permut b) /\ ((permut a b 0%Z (length a)) /\ (permut
  a b 0%Z l))))) -> (permut a b l (length a)).

Axiom permut_split_imply_permut_sub : forall (a:(array Z)) (b:(array Z))
  (l:Z), (((0%Z <= l)%Z /\ ((l < (length a))%Z /\
  ((length a) = (length b)))) /\ ((is_permut a) /\ ((is_permut b) /\ ((permut
  a b 0%Z (length a)) /\ (array_eq_sub a b 0%Z l))))) -> (permut_sub a b l
  (length a)).

Axiom array_eq_imply_permut : forall (a:(array Z)) (b:(array Z)) (l:Z) (u:Z),
  (((0%Z <= l)%Z /\ ((l < u)%Z /\ ((u <= (length a))%Z /\
  ((length a) = (length b))))) /\ (array_eq_sub a b l u)) -> (permut a b l
  u).

Axiom permut_sym : forall (a:(array Z)) (b:(array Z)) (l:Z) (u:Z), (permut a
  b l u) <-> (permut b a l u).

Axiom permut_sub_sym : forall (a:(array Z)) (b:(array Z)) (l:Z) (u:Z),
  (permut_sub a b l u) <-> (permut_sub b a l u).

Axiom array_eq_sub_sym : forall (a:(array Z)) (b:(array Z)) (l:Z) (u:Z),
  (array_eq_sub a b l u) <-> (array_eq_sub b a l u).

Axiom permut_trans : forall (a1:(array Z)) (a2:(array Z)) (a3:(array Z)),
  forall (l:Z) (u:Z), (permut a1 a2 l u) -> ((permut a2 a3 l u) -> (permut a1
  a3 l u)).

Axiom permut_sub_trans : forall (a1:(array Z)) (a2:(array Z)) (a3:(array Z)),
  forall (l:Z) (u:Z), (permut_sub a1 a2 l u) -> ((permut_sub a2 a3 l u) ->
  (permut_sub a1 a3 l u)).

Axiom array_eq_sub_trans : forall (a1:(array Z)) (a2:(array Z)) (a3:(array
  Z)), forall (l:Z) (u:Z), (array_eq_sub a1 a2 l u) -> ((array_eq_sub a2 a3 l
  u) -> (array_eq_sub a1 a3 l u)).

Axiom value_on_large_suffix : forall (a:(array Z)) (b:(array Z)) (l:Z) (u:Z),
  (((0%Z <= l)%Z /\ ((l < u)%Z /\ ((u <= (length a))%Z /\
  ((length a) = (length b))))) /\ (permut_sub a b l u)) -> exists i:Z,
  ((l <= i)%Z /\ (i < u)%Z) /\ ((get b l) = (get a i)).

Axiom value_on_strict_suffix : forall (a:(array Z)) (b:(array Z)) (l:Z)
  (u:Z), (((0%Z <= l)%Z /\ ((l < u)%Z /\ ((u <= (length a))%Z /\
  ((length a) = (length b))))) /\ ((permut_sub a b l u) /\ (lt_lex_sub_at a b
  l u l))) -> exists i:Z, ((l < i)%Z /\ (i < u)%Z) /\ ((get b l) = (get a
  i)).

(* Why3 goal *)
Theorem inc_permut : forall (a:(array Z)) (b:(array Z)) (r:Z) (j:Z),
  (((0%Z <= r)%Z /\ ((r < j)%Z /\ ((j < (length a))%Z /\
  ((length a) = (length b))))) /\ ((is_permut a) /\ ((is_dec_sub a
  (r + 1%Z)%Z (length a)) /\ ((is_permut b) /\ ((is_inc_sub b (r + 1%Z)%Z
  (length a)) /\ ((lt_lex_at a b r) /\ ((permut_sub a b r (length a)) /\
  ((im_sup1 a r j) /\ ((im_sup2 a r j) /\ ((get b r) = (get a j))))))))))) ->
  (inc a b).
(* Why3 intros a b r j
        ((h1,(h2,(h3,h4))),(h5,(h6,(h7,(h8,(h9,(h10,(h11,(h12,h13))))))))). *)

intros a b r j ((R0,(R1,(h3,len))),(h4,(h5,(h6,(h7,(h8,(h9,(h12,(h13,h14))))))))).

unfold inc.
split. apply len.
split. firstorder.
intros c (h15,(h16,h17)).
destruct h17 as [k [K [h17 h18]]].
(* Goal: le_lex_sub b c 0 (length a) *)
(* Subproof 1: permut a c 0 (length a) *)
assert (permut a c 0 (length a)) as ps0.
 apply endoinj_permut.
 split. omega.
 split. apply h4.
 apply h16.
(* Subproof 2: permut_sub a c k (length a) *)
assert (permut_sub a c k (length a)) as ps1.
 apply permut_split_imply_permut_sub.
 split. firstorder.
 split. apply h4.
 split. apply h16.
 split. apply ps0.
 apply h17.
case (Zcompare_spec k r); intro A.
- { (* A: r = k *)
 assert (array_eq_sub b c 0 k) as H2.
 apply array_eq_sub_trans with a.
 rewrite A.
 apply array_eq_sub_sym.
 apply h8.
 apply h17.
 (* Subproof: permut_sub a c k (length a) *)
 assert (permut_sub b c k (length a)) as H.
 unfold permut_sub.
 split. apply H2.
 split.
 - apply permut_trans with a.
  rewrite A.
  apply permut_sym.
  apply h9.
  apply ps1.
 - firstorder.
 - {
  case (Zcompare_spec (get b k) (get c k)); intro B.
  - { (* B: b[k] = c[k] *)
   assert (array_eq_sub b c 0 (k+1)) as L.
   - {
    repeat split; try omega.
    unfold map_eq_sub.
    intros i I.
    assert ((0 <= i < k + 1)%Z -> (0 <= i < k )%Z \/ (i=k)%Z) as E; try omega.
    apply E in I.
    destruct I as [I1|I2].
    - apply H2. apply I1.
    - rewrite I2. apply B.
   }
   - {
    apply prefix_le_lex_sub with (k+1)%Z.
    split. apply L.
    apply min_lex_sub.
    - {
     repeat split; try omega.
     apply h6.
     rewrite <- A in h7.
     apply h7.
    }
    - {
     split.
     - {
      rewrite len. apply permut_split.
      split. repeat split;try omega.
      split. apply h6.
      split. apply h16.
      split.
       apply permut_trans with a.
       apply permut_sym.
       rewrite <- len.
       apply endoinj_permut.
       firstorder.
       rewrite <- len.
       apply ps0.
       apply array_eq_imply_permut.
       split. repeat split;try omega.
       apply L.
     }
     - apply h16.
    }
   }
  }
  - { (* B: b[k] < c[k] *)
   left.
   unfold lt_lex_sub.
   exists k.
   unfold lt_lex_sub_at.
   split. apply K.
   split. unfold array_eq_sub.
   repeat split ;try omega.
   apply H2.
   apply B.
  }
  - {(* B: b[k] > c[k], not possible *)
   assert (exists i:int, (k < i < (length a))%Z /\ get c k = get a i ) as H1.
   apply value_on_strict_suffix.
   split. omega.
   split. apply ps1.
   unfold lt_lex_sub_at.
   repeat split;try omega.
   intros i I. omega.
   destruct H1 as [i[I H1]].
   unfold im_sup2 in h13; unfold im_sup1 in h12.
   assert ((k < i < (length a))%Z -> (k < i < j)%Z \/ i=j \/ (j < i < (length a))%Z) as E.
   omega.
   assert ( get b k < get a i  \/ get b k = get a i \/get a i < get a k)%Z.
   apply E in I.
   destruct I as [I|[I|I]].
   rewrite <- A in h12,h13.
   left. rewrite <- h14,<-A in h12. apply h12. omega.
   right;left. rewrite I,A. apply h14.
   right;right. rewrite A. apply h13. omega.
   omega.
  }
 }
}
- { (* A: k < r *)
 assert (get a k = get b k).
 apply h8. intuition.
 left.
 unfold lt_lex_sub,lt_lex_sub_at.
 exists k.
 split. apply K.
 split.
  apply array_eq_sub_trans with a.
  apply array_eq_sub_sym.
  firstorder.
  apply h17.
  omega.
}
- { (* A: k > r, impossible *)
 assert ((get a k < get c k )%Z) as H.
 firstorder.
 assert (forall i:int, (k < i < (length a))%Z -> (get a i < get a k )%Z) as H1.
 intros i I.
 apply h5.
 omega.
 assert (exists i:int, (k <= i < (length a))%Z /\ (get c k = get a i )%Z) as H2.
  apply value_on_large_suffix.
  split. repeat split; try omega. 
  apply ps1.
 destruct H2 as [l [L L0]].
 case (Zcompare_spec l k); intro B.
 - { (* l = k *)
  rewrite B in L0.
  omega.
 }
 - (* l < k *) omega.
 - { (* l > k *)
  assert ((get a k > get c k)%Z).
  pose proof (H1 l) as H0.
  rewrite L0.
  omega.
  omega.
 }
}
Qed.

