/*******************************************************************************/
/* Coq Unit Testing project                                                    */
/* Copyright 2015-2016 Catherine Dubois, Richard Genestier and Alain Giorgetti */
/* Samovar - FEMTO-ST institute                                                */
/*******************************************************************************/
/*      This file is distributed under the terms of the                        */
/*       GNU Lesser General Public License Version 2.1                         */
/*******************************************************************************/

/* File : bet_operations.pl

   Contents: Validation of examples/coq/operations.v by bounded-exhaustive testing (BET). */

:- compile('../../../prolog/measure'). /* For validation by counting. */
:- compile('../../../prolog/cut').     /* For validation by BET. */

:- compile('../../permutation/prolog/permut'). /* Specification of permutations. */


/* Validation that the non_isthmic operation preserves permutations. */
write_coq_non_isthmic_permut(PredSym,SizeMax)  :-
 increasing(Size,0,SizeMax),
 (settings(fd_on) -> SizeT=Size; nat2term(Size,SizeT)),
 Pred=..[PredSym,L,SizeT],  /* Pred is the generator */
 Pred, 
 increasing(I,0,Size),
 write('Eval compute in (let proof := '),
 write_coq_proof_X_leq_Y(I,Size),
 nl, 
 write(' in if (is_permutb '),
 SizeP2 is Size + 2,
 write(SizeP2),
 write(' (@non_isthmic_fun '),
 write(Size),
 write(' (list2fun ('), write_list(L), write(')) '),
 write(I),
 write(' '), 
 write('proof)) then "" else "non_isthmic_permut wrong for ('),
 write_list(L), write(')."'),
 write(').'),
 nl, flush_output,
 fail. % this causes backtracking
write_coq_non_isthmic_permut(_,_).

/* Validation that the isthmic operation preserves permutations. */
write_coq_isthmic_permut(PredSym,SizeMax)  :-
 increasing(E,0,SizeMax),
 Em1 is E - 1,
 increasing(E1,0,Em1),
 E2 is Em1 - E1,
 Size is E+E,
 Size1 is E1+E1,
 Size2 is E2+E2,
 (settings(fd_on) -> SizeT1=Size1; nat2term(Size1,SizeT1)),
 Pred1=..[PredSym,L1,SizeT1],  /* Generator of the first list L1 */
 (settings(fd_on) -> SizeT2=Size2; nat2term(Size2,SizeT2)),
 Pred2=..[PredSym,L2,SizeT2],  /* Generator of the second list L2 */
 Pred1,
 Pred2, 
 write('Eval compute in (if (is_permutb '),
 write(Size),
 write(' (isthmic_fun '),
 write(Size1),
 write(' (list2fun ('), write_list(L1), write(')) '),
 write(Size2),
 write(' (list2fun ('), write_list(L2), write(')) '),
 write(')) then "" else "isthmic_permut wrong for ('),
 write_list(L1), write(') and ('),
 write_list(L2), write(')").'),
 nl, flush_output,
 fail. % this causes backtracking
write_coq_isthmic_permut(_,_).



/* One predicate for all the validations of Coq concerning permutations. */
write_coq_operations(PredSym,SizeMax) :-
 write('Eval compute in "Test suite 1: Validation that the non_isthmic operation preserves permutations (lemma non_isthmic_permut).".'), nl,
 write_coq_non_isthmic_permut(PredSym,SizeMax), nl, nl,
 write('Eval compute in "Test suite 2: Validation that the isthmic operation preserves permutations (lemma isthmic_permut).".'), nl,
 write_coq_isthmic_permut(PredSym,SizeMax), nl, nl.


/* Coq file opening and closing, with header and time measures. */
write_coq_open_close_file(Size,PredSym,File) :-
 tell(File),
  write('(* File generated by code in ../rotation/prolog/bet_operations.pl. *)'), nl,
  write('Require Import Arith Arith.Bool_nat Omega List String.'), nl,
  write('Require Import endofun permut operations cut.'), nl, nl, 
  write('Open Scope string_scope.'), nl, nl,  
  ((system_type(sicstus);system_type(swi)) -> statistics(runtime,[T1,_]) ; true),
  ((system_type(gnu)) -> statistics(user_time,[T1,_]) ; true),
  write_coq_operations(PredSym,Size),
  ((system_type(sicstus);system_type(swi)) -> statistics(runtime,[T2,_]) ; true),
  ((system_type(gnu)) -> statistics(user_time,[T2,_]) ; true),
  Time is T2-T1,
  write('(* Time: '), write(Time), write(' ms'), write(' *)'),
 told.

/* Some output before writing in the Coq file. */
write_coq_file(Size,PredSym,File) :-
 write('-- File bet_operations.pl'), nl,
 write('Size: '), write(Size), nl,
 write('Predicate: '), write(PredSym), nl,
 write('Output file: '), write(File), nl,
 write_coq_open_close_file(Size,PredSym,File).
 
:- write_coq_file(4,line,'../../coq/val_operations.v'), halt.
